<?php
class Controllerextensiontmdsms extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/tmdsms');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/tmdsms');

		$this->getList();
	}

	public function add() {
		
		
		$this->load->language('extension/tmdsms');
		
		$this->load->model('extension/tmdsms');

		$this->document->setTitle($this->language->get('heading_title'));
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			//print_r($this->request->post); die();
			$this->model_extension_tmdsms->addtmdsms($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true));
	
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('extension/tmdsms');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/tmdsms');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_extension_tmdsms->edittmdsms($this->request->get['tmdsms_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('extension/tmdsms');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/tmdsms');

		if (isset($this->request->post['selected'])) {
			foreach ($this->request->post['selected'] as $tmdsms_id) {
				$this->model_extension_tmdsms->deleteTeacher($tmdsms_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	public function getList() {
		$this->load->model('extension/tmdsms');
		
		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = '';
		}
		
		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = '';
		}
		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('extension/tmdsms/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('extension/tmdsms/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['teachers'] = array();

		$filter_data = array(
			'filter_name' => $filter_name,
			'filter_email' => $filter_email,
			'filter_status' => $filter_status,
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		

		$sms_total = $this->model_extension_tmdsms->getTotalTeacher($filter_data);

		$results = $this->model_extension_tmdsms->getTeachers($filter_data);
		$this->load->model('tool/image');
		foreach ($results as $result) {
			
			if (!empty($result)) {
				$customers = unserialize($result['customer_id']);
			} else {
				$customers = '';
			}

			//$customers = array();
				if(!empty($customers)){
					foreach ($customers as $customer_id) {
						$customer_info = $this->model_extension_tmdsms->getcustomer($customer_id);

					if ($customer_info) {
						$customers[] = array(
						'name'       => $customer_info['firstname'].' '.$customer_info['lastname'] 
						);
					}
				}
				
			}
			
	
	
			
			$data['teachers'][] = array(
				'tmdsms_id' => $result['tmdsms_id'],
				'sms'            => $result['sms'],
				'customers'            => $customers,
				'edit'            => $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . '&tmdsms_id=' . $result['tmdsms_id'] . $url, true)
			);
			//print_r($data['teachers']);die();
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_enable'] = $this->language->get('text_enable');
		$data['text_disable'] = $this->language->get('text_disable');
		$data['text_select'] = $this->language->get('text_select');
		$data['column_name'] = $this->language->get('column_name');
		$data['column_email'] = $this->language->get('column_email');
		$data['column_image'] = $this->language->get('column_image');
		$data['column_status'] = $this->language->get('column_status');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');
		$data['column_banner'] = $this->language->get('column_banner');
		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_target'] = $this->language->get('entry_target');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');
		$data['button_filter'] = $this->language->get('button_filter');
		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$data['sort_image'] = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . '&sort=image' . $url, true);
		$data['sort_name'] = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
		$data['sort_email'] = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . '&sort=email' . $url, true);
		$data['sort_status'] = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);

		$url = '';
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}
		
		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}
		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $sms_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($sms_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($sms_total - $this->config->get('config_limit_admin'))) ? $sms_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $sms_total, ceil($sms_total / $this->config->get('config_limit_admin')));

		$data['filter_name'] = $filter_name;
		$data['filter_email'] = $filter_email;
		$data['filter_status'] = $filter_status;
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


		$this->response->setOutput($this->load->view('extension/tmdsms_list', $data));
	}

	protected function getForm() {
		$data['heading_title'] = $this->language->get('heading_title');

	
		$data['text_default'] = $this->language->get('text_default');
		$data['text_newsletter'] = $this->language->get('text_newsletter');
		$data['text_customer_all'] = $this->language->get('text_customer_all');
		$data['text_customer'] = $this->language->get('text_customer');
		$data['text_customer_group'] = $this->language->get('text_customer_group');
		$data['text_affiliate_all'] = $this->language->get('text_affiliate_all');
		$data['text_affiliate'] = $this->language->get('text_affiliate');
		$data['text_product'] = $this->language->get('text_product');
		$data['text_loading'] = $this->language->get('text_loading');

		$data['entry_store'] = $this->language->get('entry_store');
		$data['entry_to'] = $this->language->get('entry_to');
		$data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$data['entry_customer'] = $this->language->get('entry_customer');
		$data['entry_affiliate'] = $this->language->get('entry_affiliate');
		$data['entry_product'] = $this->language->get('entry_product');
		$data['entry_subject'] = $this->language->get('entry_subject');
		$data['entry_message'] = $this->language->get('entry_message');

		$data['help_customer'] = $this->language->get('help_customer');
		$data['help_affiliate'] = $this->language->get('help_affiliate');
		$data['help_product'] = $this->language->get('help_product');

		$data['button_send'] = $this->language->get('button_send');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['user_token'] = $this->session->data['user_token'];

		

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}
		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		if (isset($this->error['sms'])) {
			$data['error_sms'] = $this->error['sms'];
		} else {
			$data['error_sms'] = '';
		}
		
		
		
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['tmdsms_id'])) {
			$data['action'] = $this->url->link('extension/tmdsms/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('extension/tmdsms/edit', 'user_token=' . $this->session->data['user_token'] . '&tmdsms_id=' . $this->request->get['tmdsms_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('extension/tmdsms', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['tmdsms_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$teacher_info = $this->model_extension_tmdsms->getTeacher($this->request->get['tmdsms_id']);
		}

		if (isset($this->request->post['sms'])) {
			$data['sms'] = $this->request->post['sms'];
		} elseif (!empty($teacher_info)) {
			$data['sms'] = $teacher_info['sms'];
		} else {
			$data['sms'] = '';
		}
		if (isset($this->request->post['sms_to'])) {
			$data['sms_to'] = $this->request->post['sms_to'];
		} elseif (!empty($teacher_info)) {
			$data['sms_to'] = $teacher_info['sms_to'];
		} else {
			$data['sms_to'] = '';
		}
		if (isset($this->request->post['customer'])) {
			$customers = $this->request->post['customer'];
		} elseif (!empty($teacher_info)) {
			$customers = unserialize($teacher_info['customer_id']);
		} else {
			$customers = '';
		}


		$data['customers'] = array();
		if(!empty($customers)){
		foreach ($customers as $customer_id) {
			$customer_info = $this->model_extension_tmdsms->getcustomer($customer_id);

			if ($customer_info) {
				$data['customers'][] = array(
					'customer_id' => $customer_info['customer_id'],
					'name'       => $customer_info['firstname'].' '.$customer_info['lastname'] 
				);
			}
		}
	}

		$this->load->model('setting/store');

		$data['stores'] = $this->model_setting_store->getStores();

		$this->load->model('customer/customer_group');

		$data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();
		
		
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/tmdsms', $data));
	}

	public function managedelete(){
		$json=array();
		$this->load->language('extension/tmdsms');
		$this->load->model('extension/tmdsms');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {	
			$this->model_extension_tmdsms->deleteTeacher($this->request->get['tmdsms_id']);
			$json['success'] = $this->language->get('text_delete');
		}					
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'extension/tmdsms')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['sms']) < 1)) {
			$this->error['sms'] = $this->language->get('error_sms');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;

	}


}