<?php
class ControllerModuleSmsPluginCom extends Controller {
	private $error = array();

	public function index() {
		// Load language file(s)
		$this->language->load('module/sms_plugin_com');

		// Set document title
		$this->document->setTitle($this->language->get('heading_title'));

		// Load the settings module to access configuration
		$this->load->model('setting/setting');

		// Save the settings submitted by user
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('sms_plugin_com', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		//Get language items into an array
		$text_strings = array(
			'heading_title',
			'success',
			'text_yes',
			'text_no',
			'text_create_account',
			'text_freaquent_questions',
			'text_tab_account',
			'text_tab_account_info',
			'text_tab_actions',
			'text_tab_history',
			'text_sms_plugin_com_credentials',
			'text_sms_plugin_com_api_key',
			'text_sms_plugin_com_balance',
			'text_sms_plugin_com_username',
			'text_sms_plugin_com_password',
			'text_send_sms_recipient',
			'text_admin_notify_customer_register',
			'text_admin_notify_customer_register_message',
			'text_admin_notify_customer_register_message_template',
			'text_admin_notify_customer_checkout',
			'text_admin_notify_customer_checkout_message',
			'text_admin_notify_customer_checkout_message_template',
			'text_admin_notify_order_status',
			'text_admin_notify_order_status_message',
			'text_admin_notify_order_status_message_template',
			'text_admin_notify_additional_settings',
			'text_admin_notify_include_items',
			'text_admin_notify',
			'text_admin_mobile',
			'text_admin_sms_encoding',
			'text_admin_notifications',
			'text_customer_notify_ckeckout',
			'text_customer_notify_order_status',
			'text_customer_message',
			'text_new_orders',
			'text_new_order_sms',
			'text_new_order_sender',
			'text_new_order_sms_encoding',
			'text_new_order_message',
			'text_order_status',
			'text_order_status_sms',
			'text_order_status_sender',
			'text_order_status_sms_encoding',
			'text_order_status_message',
			'text_missing',
			'error_permission',
			'button_save',
			'button_cancel',
			'text_send_sms_sender',
			'text_send_sms_recipient',
			'text_send_sms_message',
			'text_send_sms_200',
			'text_send_sms_401',
			'text_send_sms_500',
			'column_smsplugin_id',
			'column_date_sent',
			'column_sender_id',
			'column_recipient_id',
			'column_status',
			'column_order_id',
			'column_message',
			'button_filter',
			'button_clear_filter',
			'empty_sms_history',
			'text_download_csv_history',
			'text_download',
			'text_sent',
			'text_delivered',
			'text_insufficient_balance',
			'text_failed',
			'text_send_sms',
			'text_sms_name_number',
			'text_sms_number',
			'text_send_sms_button',
			'text_send_sms_encoding',
			'text_send_sms_ucs',
			'text_send_sms_gsm',
			'text_warning_reset_key',
			'text_warning_get_key',
			'text_chars',
			'text_sms',
			'text_sms_plugin_com_api_key_reset_info',
			'text_username_required',
			'text_password_required',
			'text_sender_required',
			'text_recipient_required',
			'text_recipient_valid',
			'text_message_required',
			'text_new_order_message_template',
			'text_order_status_message_template',
			'text_sms_plugin_com_api_key_placeholder',
			'text_sms_plugin_com_username_placeholder',
			'text_sms_plugin_com_password_placeholder',
			'text_sms_plugin_com_getkey_button',
			'text_sms_plugin_com_resetkey_button',
			'text_sidebar_heading',
			'text_sms_plugin_for_opencart',
			'text_sidebar_module_info',
			'text_required_field',
			'text_sms_plugin_com_key_info_balloon',
			'text_sms_plugin_com_username_info_balloon',
			'text_sms_plugin_com_password_info_balloon',
			'text_send_sms_sender_info_balloon',
			'text_send_sms_recipient_info_balloon',
			'text_send_sms_encoding_info_balloon',
			'text_send_sms_text_info_balloon',
			'text_new_order_sms_info_balloon',
			'text_new_order_sender_info_balloon',
			'text_new_order_sms_encoding_info_balloon',
			'text_new_order_message_info_balloon',
			'text_order_status_sms_info_balloon',
			'text_order_status_sms_sender_info_balloon',
			'text_order_status_sms_encoding_info_balloon',
			'text_order_status_sms_message_info_balloon',
			'text_admin_notify_info_balloon',
			'text_admin_mobile_info_balloon',
			'text_admin_sms_encoding_info_balloon',
			'text_admin_notify_customer_register_balloon',
			'text_admin_notify_customer_register_message_info_balloon',
			'text_admin_notify_customer_checkout_info_balloon',
			'text_admin_notify_customer_checkout_message_info_balloon',
			'text_admin_notify_order_status_info_balloon',
			'text_admin_notify_order_status_message_info_balloon',
			'text_sms_plugin_com_get_key_200',
			'text_sms_plugin_com_reset_key_200',
			'text_sms_plugin_com_get_reset_key_401',
			'text_sms_plugin_com_get_reset_key_500'
		);

		// Loop through language array and set to controller data
		foreach ($text_strings as $text) {
			$this->data[$text] = $this->language->get($text);
		}

		// Get configuration either by submitted user data or from database
		$config_data = array(
			'token',
			'sms_plugin_com_api_key',
			'sms_plugin_com_api_key_valid',
			'sms_plugin_com_balance',
			'admin_notify',
			'admin_mobile',
			'admin_sms_encoding',
			'admin_notify_customer_register',
			'admin_notify_new_account_message',
			'admin_notify_customer_checkout',
			'admin_notify_customer_checkout_message',
			'admin_notify_order_status',
			'admin_notify_order_status_message',
			'admin_notify_include_order_items',
			'customer_notify_ckeckout',
			'customer_notify_order_status',
			'new_order_enabled',
			'new_order_sender',
			'new_order_sms_encoding',
			'new_order_message',
			'order_status_enabled',
			'order_status_sender',
			'order_status_sms_encoding',
			'order_status_message',
			'sms_plugin_com_invalid_api_key',
			'sms_list',
			'sort',
			'sort_sms_plugin_com_id',
			'sort_date_sent',
			'sort_status',
			'sort_order_id',
			'filter_smsplugin_id',
			'filter_date_sent',
			'filter_sender_id',
			'filter_recipient_id',
			'filter_message',
			'filter_order_id',
			'filter_status_id',
			'sms_statuses',
			'pagination'
		);

		// Loop throught config array and set to controller data
		foreach ($config_data as $conf) {
			if (isset($this->request->post[$conf])) {
				$this->data[$conf] = $this->request->post[$conf];
			} else {
				$this->data[$conf] = $this->config->get($conf);
			}
		}

		// Set API key valid to 1
		$this->data['sms_plugin_com_api_key_valid'] = 1;

		// Set token
		$this->data['token'] = $this->session->data['token'];

		// Setup sms list
		$this->data['sms_list'] = array();

		// Get balance upon module edit
		if(!$this->data['sms_plugin_com_api_key']) {
			$this->data['sms_plugin_com_balance'] = 0;
		}
		else {
		   $this->getBalance();
		}

		// Error handling
		 if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		 if (isset($this->error['code'])) {
			$this->data['error_code'] = $this->error['code'];
		} else {
			$this->data['error_code'] = '';
		}

		// Breadcrumbs
		  $this->data['breadcrumbs'] = array();

		   $this->data['breadcrumbs'][] = array(
			   'text'      => $this->language->get('text_home'),
				 'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			   'separator' => false
		   );

		   $this->data['breadcrumbs'][] = array(
			   'text'      => $this->language->get('text_module'),
				 'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
			   'separator' => ' :: '
		   );

		   $this->data['breadcrumbs'][] = array(
			   'text'      => $this->language->get('heading_title'),
				 'href'      => $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'], 'SSL'),
			   'separator' => ' :: '
		   );

		// Action handling
		$this->data['action'] = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		// Set module layout
		$this->data['modules'] = array();

		if (isset($this->request->post['sms_plugin_com_module'])) {
			$this->data['modules'] = $this->request->post['sms_plugin_com_module'];
		} elseif ($this->config->get('sms_plugin_com_module')) {
			$this->data['modules'] = $this->config->get('sms_plugin_com_module');
		}

		$this->load->model('design/layout');

		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		$this->template = 'module/sms_plugin_com.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		// Get SMS list
		$this->getSmsList();

		$this->response->setOutput($this->render());
	}

	// Used for module installation
	public function install() {

		$this->load->model('module/sms_plugin_com');

		$this->model_module_sms_plugin_com->createSmsPluginComTables();
	}

	// Used for module uninstallation
	public function uninstall() {

		$this->load->model('module/sms_plugin_com');

		$this->model_module_sms_plugin_com->deleteSmsPluginComTables();
	}

	// Any validations here
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/sms_plugin_com')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function getBalance() {
		if($this->data['sms_plugin_com_api_key']) {
			try {
				// get balance
				$response = SmsPluginComApi::Instance()->getBalance($this->data['sms_plugin_com_api_key']);
				if(200 !== $response['status_code']) {
					$this->data['sms_plugin_com_balance'] = 0;
					$this->data['sms_plugin_com_api_key_valid'] = 0;
				}
				else {
					$this->data['sms_plugin_com_balance'] = $response['body']['balance'];
				}
			} catch(Exception $e) {
				echo $e;
			}
		}
	}

	// Get API key
	public function getKey() {
		$username = $_REQUEST['user'];
		$password = $_REQUEST['pass'];
		$reset = $_REQUEST['reset'];
		$response;
		if(!$username || !$password)
			echo "Username/Password are missing";

		// Set API username/password
		SmsPluginComApi::Instance()->setApi($username, $password);

		try {
			if($reset === 'true')
				$response = SmsPluginComApi::Instance()->getKey(true);
			else
				$response = SmsPluginComApi::Instance()->getKey(false);

			echo json_encode($response);
		} catch(Exception $e) {
			echo $e;
		}
	}

	// Send SMS
	public function sendSMS() {
		$data = $_REQUEST;
		try {
			$response = SmsPluginComApi::Instance()->sendSMS($this->config->get('sms_plugin_com_api_key'), $data['from'], $data['to'], $data['message'], $data['encoding']);
			// $response = array(
			// 	"status_code" => 200,
			// 	"body" => array(
			// 		"status" => "1",
			// 		"id" => 987654324,
			// 		"balance" => 72,
			// 		"mcc" => 202,
			// 		"mnc" => 01,
			// 		"remarks" => "Success: Accepted for delivery",
			// 		"error" => 0
			// 	)
			// );
			if(200 !== $response['status_code']) {
				echo $response['body']['error'];
			}
			else {
				SmsPluginComApi::Instance()->logResponse($response, $data['from'], $data['to'], $data['message'], 's', $data['encoding'], 0);
				echo json_encode($response);
			}
		} catch(Exception $e) {
			echo $e;
		}

	}

	// Get SMS list
	public function getSmsList() {
		// Load model
		$this->load->model('module/sms_plugin_com');

		// Check request for filters
		if (isset($this->request->get['filter_smsplugin_id'])) {
			$filter_smsplugin_id = $this->request->get['filter_smsplugin_id'];
		} else {
			$filter_smsplugin_id = null;
		}

		if (isset($this->request->get['filter_date_sent'])) {
			$filter_date_sent = $this->request->get['filter_date_sent'];
		} else {
			$filter_date_sent = null;
		}

		if (isset($this->request->get['filter_sender_id'])) {
			$filter_sender_id = $this->request->get['filter_sender_id'];
		} else {
			$filter_sender_id = null;
		}

		if (isset($this->request->get['filter_recipient_id'])) {
			$filter_recipient_id = $this->request->get['filter_recipient_id'];
		} else {
			$filter_recipient_id = null;
		}

		if (isset($this->request->get['filter_message'])) {
			$filter_message = $this->request->get['filter_message'];
		} else {
			$filter_message = null;
		}

		if (isset($this->request->get['filter_status_id'])) {
			$filter_status_id = $this->request->get['filter_status_id'];
		} else {
			$filter_status_id = null;
		}

		if (isset($this->request->get['filter_order_id'])) {
			$filter_order_id = $this->request->get['filter_order_id'];
		} else {
			$filter_order_id = null;
		}

		// Sort based on send timestamp
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'sms.send_tsstamp';
		}

		// Sort order
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		// Check request for page number
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		// Setup url
		$url = '';
		if (isset($this->request->get['filter_smsplugin_id'])) {
			$url .= '&filter_smsplugin_id=' . $this->request->get['filter_smsplugin_id'];
		}

		if (isset($this->request->get['filter_date_sent'])) {
			$url .= '&filter_date_sent=' . $this->request->get['filter_date_sent'];
		}

		if (isset($this->request->get['filter_sender_id'])) {
			$url .= '&filter_sender_id=' . urlencode(html_entity_decode($this->request->get['filter_sender_id'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_recipient_id'])) {
			$url .= '&filter_recipient_id=' . $this->request->get['filter_recipient_id'];
		}

		if (isset($this->request->get['filter_message'])) {
			$url .= '&filter_message=' . urlencode(html_entity_decode($this->request->get['filter_message'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_status_id'])) {
			$url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}

		if (isset($this->request->get['filter_order_id'])) {
			$url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data = array(
			'filter_smsplugin_id' 	=> $filter_smsplugin_id,
			'filter_date_sent' 		=> $filter_date_sent,
			'filter_sender_id' 		=> $filter_sender_id,
			'filter_recipient_id' => $filter_recipient_id,
			'filter_message' 			=> $filter_message,
			'filter_status_id' 		=> $filter_status_id,
			'filter_order_id' 		=> $filter_order_id,
			'sort'								=> $sort,
			'order'               => $order,
			'start'								=> ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'								=> $this->config->get('config_admin_limit')
		);

		$smsTotal = $this->model_module_sms_plugin_com->getTotalSms($data);
		$smsList = $this->model_module_sms_plugin_com->getSmsList($data);

		foreach($smsList as $sms) {
			$this->data['sms_list'][] = array(
				'smsplugin_id'     	=> $sms['smsplugin_id'],
				'send_tstamp'     => date($this->language->get('datetime_format_short'), strtotime($sms['send_tstamp'])),
				'status'        	=> $sms['status'],
				'sender_id'       => $sms['sender_id'],
				'recipient_id'		=> $sms['to'],
				'message'					=> $sms['message'],
				'order_id'				=> $sms['order_id']
			);
		}

		$this->data['sort_smsplugin_id'] = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'] . '&sort=sms.smsplugin_id' . $url, 'SSL');
		$this->data['sort_date_sent'] = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'] . '&sort=sms.send_tstamp' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'] . '&sort=sms.status' . $url, 'SSL');
		$this->data['sort_order_id'] = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'] . '&sort=sms.order_id' . $url, 'SSL');

		$pagination = new Pagination();
		$pagination->total = $smsTotal;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('module/sms_plugin_com', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();

		$this->data['filter_smsplugin_id'] = $filter_smsplugin_id;
		$this->data['filter_date_sent'] = $filter_date_sent;
		$this->data['filter_sender_id'] = $filter_sender_id;
		$this->data['filter_recipient_id'] = $filter_recipient_id;
		$this->data['filter_message'] = $filter_message;
		$this->data['filter_status_id'] = $filter_status_id;
		$this->data['filter_order_id'] = $filter_order_id;

		$this->data['sms_statuses'] = array(
				array('status_id' => 's', 'status_name' => $this->language->get('text_sent')),
				array('status_id' => 'd', 'status_name' => $this->language->get('text_delivered')),
				array('status_id' => 'f', 'status_name' => $this->language->get('text_insufficient_balance')),
				array('status_id' => 'b', 'status_name' => $this->language->get('text_failed'))
		);
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

	}

	public function getCSV() {
		// Load model
		$this->load->model('module/sms_plugin_com');
		$smsList = $this->model_module_sms_plugin_com->getSmsList([]);

		if($smsList) {
			// Set headers
			header("Content-type: text/csv");
			header("Cache-Control: no-store, no-cache");
			header('Content-Disposition: attachment; filename="sms_history.csv"');
			$out = fopen('php://output', 'w');
			foreach($smsList as &$row) {
				foreach($row as &$field) {
					$field = addslashes($field);
					//$field = '"' . addslashes($field) . '"';
				}
				//Prepare CSV
				fputcsv($out, $row);
			}
			fclose($out);
		}

	}

	// Resfresh Balance
	public function refreshBalance() {
		try {
			$key = $this->config->get('sms_plugin_com_api_key');
			if($key) {
				// get balance
				$response = SmsPluginComApi::Instance()->getBalance($key);
				if(200 !== $response['status_code']) {
					echo '0';
				}
				else {
					echo $response['body']['balance'];
				}
			} else {
				echo $text_warning_reset_key;
			}
		} catch(Exception $e) {
			echo $e;
		}
	}

	public function getKeyData() {
		$this->language->load('module/sms_plugin_com');
		$json = array(
			'text_username_required' => $this->language->get('text_username_required'),
			'text_password_required' => $this->language->get('text_password_required'),
			'text_sms_plugin_com_get_key_200' => $this->language->get('text_sms_plugin_com_get_key_200'),
			'text_sms_plugin_com_reset_key_200' => $this->language->get('text_sms_plugin_com_reset_key_200'),
			'text_sms_plugin_com_get_reset_key_401' => $this->language->get('text_sms_plugin_com_get_reset_key_401'),
			'text_sms_plugin_com_get_reset_key_500' => $this->language->get('text_sms_plugin_com_get_reset_key_500'),
		);
		echo json_encode($json);
	}

	public function getSendSmsData() {
		$this->language->load('module/sms_plugin_com');
		$json = array(
			'text_sender_required' => $this->language->get('text_sender_required'),
			'text_recipient_required' => $this->language->get('text_recipient_required'),
			'text_message_required' => $this->language->get('text_message_required'),
			'text_send_sms_200' => $this->language->get('text_send_sms_200'),
			'text_send_sms_401' => $this->language->get('text_send_sms_401'),
			'text_send_sms_500' => $this->language->get('text_send_sms_500')
		);
		echo json_encode($json);
	}

	public function getSubmitFormData() {
		$this->language->load('module/sms_plugin_com');
		$json = array(
			'text_sender_required' => $this->language->get('text_sender_required'),
			'text_message_required' => $this->language->get('text_message_required'),
		);
		echo json_encode($json);
	}


}
