<?php
class ModelModuleSmsPluginCom extends Model {
    // Create sms_plugin_com table if it does not exist
    public function createSmsPluginComTables() {
        $sql = "CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "sms_plugin_com` (
                `smsplugin_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `send_tstamp` datetime NOT NULL,
                `sender_id` text NOT NULL,
                `to` text NOT NULL,
                `message` text NOT NULL,
                `status` text NOT NULL,
                `status_tstamp` datetime NOT NULL,
                `gsm_encoding` binary NOT NULL,
                `order_id` int(10) unsigned DEFAULT NULL,
                PRIMARY KEY (`smsplugin_id`)
             )";
        $query = $this->db->query($sql);
    }

    // On uninstall delete sms_plugin_com table
    public function deleteSmsPluginComTables() {
        $query = $this->db->query("DROP TABLE IF EXISTS " . DB_PREFIX . "sms_plugin_com");
    }

    // Get total sms records
    public function getTotalSms($data = array()) {
      $sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "sms_plugin_com`";

  		if (isset($data['filter_status_id']) && !is_null($data['filter_status_id']) && $data['filter_status_id'] != "*") {
  			$sql .= " WHERE status = '" . $data['filter_status_id'] . "'";
  		} else {
  			$sql .= " WHERE status != ''";
  		}

  		if (!empty($data['filter_smsplugin_id'])) {
  			$sql .= " AND smsplugin_id = '" . (int)$data['filter_smsplugin_id'] . "'";
  		}

  		if (!empty($data['filter_date_sent'])) {
  			$sql .= " AND send_tstamp BETWEEN STR_TO_DATE('" . $this->db->escape($data['filter_date_sent']).
  					" 00:00:00', '%d-%m-%Y %H:%i:%s') AND STR_TO_DATE('" . $this->db->escape($data['filter_date_sent']).
  					" 23:59:59', '%d-%m-%Y %H:%i:%s')";
  		}

          if (!empty($data['filter_sender_id'])) {
  			$sql .= " AND sender_id LIKE '%" . $data['filter_sender_id'] . "%'";
  		}

          if (!empty($data['filter_recipient_id'])) {
  			$sql .= " AND `to` = '" . $data['filter_recipient_id'] . "'";
  		}

  		if (!empty($data['filter_message'])) {
  			$sql .= " AND message LIKE '%" . $data['filter_message'] . "%'";
  		}

          if (!empty($data['filter_order_id'])) {
  			$sql .= " AND order_id = '" . (int)$data['filter_order_id'] . "'";
  		}

  		$query = $this->db->query($sql);

  		return $query->row['total'];
    }

    // Get sms list
    public function getSmsList($data = array()) {
      $sql = "SELECT * FROM `" . DB_PREFIX . "sms_plugin_com` sms";

  		if (isset($data['filter_status_id']) && !is_null($data['filter_status_id']) && $data['filter_status_id'] != "*") {
  			$sql .= " WHERE sms.status = '" . $data['filter_status_id'] . "'";
  		} else {
  			$sql .= " WHERE sms.status != ''";
  		}

  		if (!empty($data['filter_smsplugin_id'])) {
  			$sql .= " AND sms.smsplugin_id = '" . (int)$data['filter_smsplugin_id'] . "'";
  		}

  		if (!empty($data['filter_date_sent'])) {
  			$sql .= " AND sms.send_tstamp BETWEEN STR_TO_DATE('" . $this->db->escape($data['filter_date_sent']).
  					" 00:00:00', '%d-%m-%Y %H:%i:%s') AND STR_TO_DATE('" . $this->db->escape($data['filter_date_sent']).
  					" 23:59:59', '%d-%m-%Y %H:%i:%s')";
  		}

      if (!empty($data['filter_sender_id'])) {
  			$sql .= " AND sms.sender_id LIKE '%" . $data['filter_sender_id'] . "%'";
  		}

          if (!empty($data['filter_recipient_id'])) {
  			$sql .= " AND sms.`to` = '" . $data['filter_recipient_id'] . "'";
  		}

  		if (!empty($data['filter_message'])) {
  			$sql .= " AND sms.message LIKE '%" . $data['filter_message'] . "%'";
  		}

          if (!empty($data['filter_order_id'])) {
  			$sql .= " AND order_id = '" . (int)$data['filter_order_id'] . "'";
  		}

  		$sort_data = array(
  			'sms.smsplugin_id',
  			'sms.send_tstamp',
  			'sms.status',
  			'sms.order_id'
  		);


  		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
  			$sql .= " ORDER BY " . $data['sort'];
  		} else {
  			$sql .= " ORDER BY sms.send_tstamp";
  		}

  		if (isset($data['order']) && ($data['order'] == 'DESC')) {
  			$sql .= " DESC";
  		} else {
  			$sql .= " ASC";
  		}

  		if (isset($data['start']) || isset($data['limit'])) {
  			if ($data['start'] < 0) {
  				$data['start'] = 0;
  			}

  			if ($data['limit'] < 1) {
  				$data['limit'] = 20;
  			}

  			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
  		}

  		$query = $this->db->query($sql);

  		return $query->rows;
    }

}
?>
