
/*************  FUNCTIONS *********************/
function initPrototypes() {
  String.prototype.checkSenderId = function(){
    var i = 0, c = 0, r ='',
        s = this,
        numericSenderId = "+1234567890",
        allowedChars = ":;+-.!0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    for ( i = 0; i < s.length; i++ ){
        if ( allowedChars.indexOf( s.charAt( i ) ) > -1 ){
            r += s.charAt( i );
        }
    }
    //check if alpha or numeric and fix the length
    for ( i = 0; i < r.length; i++ ){
        if ( numericSenderId.indexOf( r.charAt( i ) ) > -1 ){
            c++;
        }
    }
    if ( c == r.length ){ // numeric
        return r.substring(0, 16);
    }else{ // alpha
        return r.substring(0, 11);
    }
  }
}

function charCount(encoding, currentText) {
  var length = 0;
  if(encoding == '2') {
    length = currentText.length;
  } else if(encoding == '1') {
    for ( d = 0; d < currentText.length; d++) {
      n = currentText.charCodeAt(d);
      switch (n){
        case 12:
        case 91:
        case 92:
        case 93:
        case 94:
        case 123:
        case 124:
        case 125:
        case 126:
        case 8364:
          length += 2;
          break;
        default:
          length++;
      }
    }
  }
  return length;
}


function setCounters(charCounterId, smsCounterId, encodingValue, length) {
  jQuery(charCounterId).text(length);
  if(encodingValue === '2') {
    jQuery(smsCounterId).text(Math.ceil(length/67));
  } else {
    jQuery(smsCounterId).text(Math.ceil(length/157));
  }
}

function addValidationRules(rules){
    for (var item in rules){
      $('#'+item).rules('add', rules[item]);
    }
}

function removeValidationRules(rules){
    for (var item in rules){
       $('#'+item).rules('remove');
    }
}

function ajaxCall(type, params, data, callback, next) {
   $.ajax({
      type: type,
      url: params.url,
      data: data,
      success: function(response) {
          response = JSON.parse(response);
          if(response.status_code) {
            switch(response.status_code) {
              case 200:
                 callback(response, params.message_200);
                 break;
              case 401:
                 callback(response, params.message_401);
                 break;
              case 402:
                 callback(response, params.message_402);
                 break;
              case 500:
                 callback(response, params.message_500);
                 break;
            }
        } else {
          callback(response);
        }
      }
    }).done(function() {
       if(undefined !== next) {
         next();
       }
    });
}

function smsPluginComTooltip(elementId, position, tooltipId, tooltipPosition, tooltipSize, message, timeout)  {
  var html = '<div id="' + tooltipId + '" data-balloon="' + message
              + '" data-balloon-pos="' + tooltipPosition + '"'
              + '" data-balloon-length="' + tooltipSize + '"'
              + ' data-balloon-visible></div>';
  switch(position) {
    case "before":
      $('#' + elementId).before(html);
      break;
    case "after":
      $('#' + elementId).after(html);
      break;
  }
  setTimeout(function() {
    $('#' + tooltipId).remove();
  }, timeout);
}

// function getSubmitFormData() {
//   var params = {
//     "url": 'index.php?route=module/sms_plugin_com/getSubmitFormData&token='+token
//   };
//
//   ajaxCall('POST', params, {}, function(response, message) {
//     submitFormData = response;
//     submitFormRules = {
//           new_order_sender: {
//               required: {
//                 depends: function()
//                 {
//                   if($('#new_order_enabled').val() == 1)
//                   {
//                     var value = $("#new_order_sender").val();
//                     $("#new_order_sender").val(value.checkSenderId());
//                     return true;
//                   }
//                 }
//               },
//               messages: {
//                 required: submitFormData.text_sender_required
//               }
//           },
//           new_order_message: {
//               required: function() {
//                 return $('#new_order_enabled').val() == 1
//               },
//               messages: {
//                 required: submitFormData.text_message_required
//               }
//           },
//           order_status_sender: {
//               required: {
//                 depends: function()
//                 {
//                   if($('#order_status_enabled').val() == 1)
//                   {
//                     var value = $("#order_status_sender").val();
//                     $("#order_status_sender").val(value.checkSenderId());
//                     return true;
//                   }
//                 }
//               },
//               messages: {
//                 required: submitFormData.text_sender_required
//               }
//           },
//           order_status_message: {
//               required: function() {
//                 return $('#order_status_enabled').val() == 1
//               },
//               messages: {
//                 required: submitFormData.text_message_required
//               }
//           },
//           admin_mobile: {
//               required: function() {
//                 return $('#admin_notify').val() == 1
//               },
//               messages: {
//                 required: submitFormData.text_sender_required
//               }
//           },
//           admin_notify_new_account_message: {
//               required: function() {
//                 return $('#admin_notify').val() == 1 && $('#admin_notify_customer_register').is(':checked')
//               },
//               messages: {
//                 required: submitFormData.text_message_required
//               }
//           },
//           admin_notify_customer_checkout_message: {
//               required: function() {
//                 return $('#admin_notify').val() == 1 && $('#admin_notify_customer_checkout').is(':checked')
//               },
//               messages: {
//                 required: submitFormData.text_message_required
//               }
//           },
//           admin_notify_order_status_message: {
//               required: function() {
//                 return $('#admin_notify').val() == 1 && $('#admin_notify_order_status').is(':checked')
//               },
//               messages: {
//                 required: submitFormData.text_message_required
//               }
//           },
//         };
//   });
// }

// Submit form function
function submitForm() {
  addValidationRules(submitFormRules);
  if($("#form_sms_plugin_com").valid()) {
    $('#form_sms_plugin_com').submit();
  }
  removeValidationRules(submitFormRules);
}

/************** ELEMENT ACTIONS *********************/

// Store selected tab in localStorage
$('#tabs a').click(function(e) {
  e.preventDefault();
  $(this).tab('show');
});

// store the currently selected tab in the hash value
$("ul.nav-tabs > li > a").on("shown.bs.tab", function(e) {
  var id = $(e.target).attr("href").substr(1);
  window.location.hash = id;
});

// TABS
$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
  var target = $(e.target).attr('href') // activated tab
  var id = target.substr(1);
  window.location.hash = id;
  if('#tab-history' == target) {
    $('#about-sidebar').addClass('hidden');
    $('#sms-plugin-csv-button').removeClass('hidden');
    $('#container-panel').removeClass('col-sm-8').addClass('col-sm-12');
  } else {
    $('#about-sidebar').removeClass("hidden");
    $('#sms-plugin-csv-button').addClass('hidden');
    $('#container-panel').removeClass('col-sm-12').addClass('col-sm-8');
  }
});

// on load of the page: switch to the currently selected tab
var hash = window.location.hash;
$('#tabs a[href="' + hash + '"]').tab('show');

// Catch enter/return keystrokes
$('#history-table input').keydown(function(e) {
  if (e.keyCode == 13) {
    filter();
  }
});

$(document).ready(function(){

  initPrototypes();
  // getSubmitFormData();

  // Datepickers
  $('.date').datepicker({dateFormat: 'dd-mm-yy'});

  if(2 == $('#admin_notify').val()) {
    $('#admin-settings-messages').hide();
  }

  if(!$('#admin_notify_customer_register').is(':checked')) {
    $('.admin_notify_new_account_message').hide();
  }

  if(!$('#admin_notify_customer_checkout').is(':checked')) {
    $('.admin_notify_customer_checkout_message').hide();
  }

  if(!$('#admin_notify_order_status').is(':checked')) {
    $('.admin_notify_order_status_message').hide();
  }

  $('#form_sms_plugin_com').validate({});
});
