var submitFormData = {};
var submitFormRules = {};

(function() {
  var params = {
    "url": 'index.php?route=module/sms_plugin_com/getSubmitFormData&token='+token
  };

  ajaxCall('POST', params, {}, function(response, message) {
    submitFormData = response;
    submitFormRules = {
          new_order_sender: {
              required: {
                depends: function()
                {
                  if($('#new_order_enabled').val() == 1)
                  {
                    var value = $("#new_order_sender").val();
                    $("#new_order_sender").val(value.checkSenderId());
                    return true;
                  }
                }
              },
              messages: {
                required: submitFormData.text_sender_required
              }
          },
          new_order_message: {
              required: function() {
                return $('#new_order_enabled').val() == 1
              },
              messages: {
                required: submitFormData.text_message_required
              }
          },
          order_status_sender: {
              required: {
                depends: function()
                {
                  if($('#order_status_enabled').val() == 1)
                  {
                    var value = $("#order_status_sender").val();
                    $("#order_status_sender").val(value.checkSenderId());
                    return true;
                  }
                }
              },
              messages: {
                required: submitFormData.text_sender_required
              }
          },
          order_status_message: {
              required: function() {
                return $('#order_status_enabled').val() == 1
              },
              messages: {
                required: submitFormData.text_message_required
              }
          },
          admin_mobile: {
              required: function() {
                return $('#admin_notify').val() == 1
              },
              messages: {
                required: submitFormData.text_sender_required
              }
          },
          admin_notify_new_account_message: {
              required: function() {
                return $('#admin_notify').val() == 1 && $('#admin_notify_customer_register').is(':checked')
              },
              messages: {
                required: submitFormData.text_message_required
              }
          },
          admin_notify_customer_checkout_message: {
              required: function() {
                return $('#admin_notify').val() == 1 && $('#admin_notify_customer_checkout').is(':checked')
              },
              messages: {
                required: submitFormData.text_message_required
              }
          },
          admin_notify_order_status_message: {
              required: function() {
                return $('#admin_notify').val() == 1 && $('#admin_notify_order_status').is(':checked')
              },
              messages: {
                required: submitFormData.text_message_required
              }
          },
        };
  });
})();

// Clear New order Sender and message if disabled
$("#new_order_enabled").change(function() {
  if($(this).val() == 2) {
    $('#new_order_sender').val("");
    $('#new_order_message').val("");
  }
});

// Clear Order Status Sender and message if disabled
$("#order_status_enabled").change(function() {
  if($(this).val() == 2) {
    $('#order_status_sender').val("");
    $('#order_status_message').val("");
  }
});

$('#admin_notify').change(function() {
  if(1 == this.value) {
    $('#admin-settings-messages').slideDown();
  } else if(2 == this.value) {
    $('#admin-settings-messages').slideUp();
  }
});

$('#admin_notify_customer_register').change(function(){
  if($(this).is(':checked')){
    $('.admin_notify_new_account_message').show();
  } else {
    $('.admin_notify_new_account_message').hide();
  }
});

$('#admin_notify_customer_checkout').change(function(){
  if($(this).is(':checked')){
    $('.admin_notify_customer_checkout_message').show();
  } else {
    $('.admin_notify_customer_checkout_message').hide();
  }
});

$('#admin_notify_order_status').change(function(){
  if($(this).is(':checked')){
    $('.admin_notify_order_status_message').show();
  } else {
    $('.admin_notify_order_status_message').hide();
  }
});

$('#new_order_sms_encoding').change(function() {
  var length = charCount(this.value, $('#new_order_message').val());
  setCounters('#new_order_char_counter', '#new_order_sms_counter', this.value, length);
});

$('#new_order_message').keyup(function() {
    var length = charCount($('#new_order_sms_encoding').val(), $('#new_order_message').val());
    setCounters('#new_order_char_counter', '#new_order_sms_counter', $('#new_order_sms_encoding').val(), length);
});

$('#order_status_sms_encoding').change(function() {
  var length = charCount(this.value, $('#order_status_message').val());
  setCounters('#order_status_char_counter', '#order_status_sms_counter', this.value, length);
});

$('#order_status_message').keyup(function() {
    var length = charCount($('#order_status_sms_encoding').val(), $('#order_status_message').val());
    setCounters('#order_status_char_counter', '#order_status_sms_counter', $('#order_status_sms_encoding').val(), length);
});

$('#admin_sms_encoding').change(function() {
  var length = charCount(this.value, $('#admin_notify_new_account_message').val());
  setCounters('#admin_notify_new_account_char_counter', '#admin_notify_new_account_sms_counter', this.value, length);

  length = charCount(this.value, $('#admin_notify_customer_checkout_message').val());
  setCounters('#admin_notify_customer_checkout_char_counter', '#admin_notify_customer_checkout_sms_counter', this.value, length);

  length = charCount(this.value, $('#admin_notify_order_status_message').val());
  setCounters('#admin_notify_order_status_char_counter', '#admin_notify_order_status_sms_counter', this.value, length);
});

$('#admin_notify_new_account_message').keyup(function() {
    var length = charCount($('#admin_sms_encoding').val(), $('#admin_notify_new_account_message').val());
    setCounters('#admin_notify_new_account_char_counter', '#admin_notify_new_account_sms_counter', $('#admin_sms_encoding').val(), length);
});

$('#admin_notify_customer_checkout_message').keyup(function() {
    var length = charCount($('#admin_sms_encoding').val(), $('#admin_notify_customer_checkout_message').val());
    setCounters('#admin_notify_customer_checkout_char_counter', '#admin_notify_customer_checkout_sms_counter', $('#admin_sms_encoding').val(), length);
});

$('#admin_notify_order_status_message').keyup(function() {
    var length = charCount($('#admin_sms_encoding').val(), $('#admin_notify_order_status_message').val());
    setCounters('#admin_notify_order_status_char_counter', '#admin_notify_order_status_sms_counter', $('#admin_sms_encoding').val(), length);
});
