var getSendSmsData = {};
var sendSmsRules = {};

(function () {
  var params = {
    url: 'index.php?route=module/sms_plugin_com/getSendSmsData&token='+token,
  };

  ajaxCall('POST', params, {}, function(response, message) {
      getSendSmsData = response;
      sendSmsRules = {
        send_sms_sender: {
          required: {
            depends: function() {
              var value = $("#send_sms_sender").val();
              value.checkSenderId();
              return true;
            }
          },
          messages: {
            required: getSendSmsData.text_sender_required
          }
        },
        send_sms_recipient: {
          required: true,
          messages: {
            required:  getSendSmsData.text_recipient_required
          }
        },
        send_sms_message: {
          required: true,
          messages: {
            required: getSendSmsData.text_message_required
          }
        }
      };
  });
})();

$('#send_sms_encoding').change(function() {
  var length = charCount(this.value, $('#send_sms_message').val());
  setCounters('#send_sms_char_counter', '#send_sms_counter', this.value, length);
});

// SMS text keyup handler
$('#send_sms_message').keyup(function() {
    var length = charCount($('#send_sms_encoding').val(), $('#send_sms_message').val());
    setCounters('#send_sms_char_counter', '#send_sms_counter', $('#send_sms_encoding').val(), length);
});

// Send SMS to API via AJAX
function sendSMS() {
  addValidationRules(sendSmsRules);

  if($("#form_sms_plugin_com").valid()) {
    var data = {
      "from": $('#send_sms_sender').val(),
      "to": $('#send_sms_recipient').val(),
      "message": $('#send_sms_message').val(),
      "encoding": $("#admin_sms_encoding").val()
    };

    var url = "index.php?route=module/sms_plugin_com/sendSMS&token="+token;
    var params = {
      "url": url,
      "message_200": getSendSmsData.text_send_sms_200,
      "message_401": getSendSmsData.text_send_sms_401,
      "message_500": getSendSmsData.text_send_sms_500
    };

    ajaxCall('POST', params, data, function(response, message) {
        smsPluginComTooltip( 'send_sms_sender','before','send-sms-tooltip','up','large',message,'5000' );
    }, function() {
        getBalance();
    });
    removeValidationRules(sendSmsRules);
  }
}
