<?php
class ControllerModuleSmsPluginCom extends Controller {
  protected function index() {
    $this->language->load('module/sms_plugin_com');
    $this->data['heading_title'] = $this->language->get('heading_title');

    if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/sms_plugin_com.tpl')) {
      $this->template = $this->config->get('config_template') . '/template/module/sms_plugin_com.tpl';
    } else {
      $this->template = 'default/template/module/sms_plugin_com.tpl';
    }

    $this->render();
  }

  // This is called by SMS Plugin API after an sms message is sent
  public function smsCallback() {
    if(isset($_REQUEST['msgid']) && isset($_REQUEST['status'])) {
      $result = SmsPluginComApi::Instance()->updateResponse($_REQUEST['msgid'], $_REQUEST['status']);
    }
  }
}
?>
