<?php
// SMS Plugin library class
final class SmsPluginComApi {

	// Protected class properties
	protected $sms_plugin_com_username;
	protected $sms_plugin_com_password;
	protected $sms_plugin_com_get_key_api = 'https://easysms.gr/api/key/get';
	protected $sms_plugin_com_reset_key_api = 'https://easysms.gr/api/key/reset';
	protected $sms_plugin_com_balance_api = 'https://easysms.gr/api/balance/get';
	protected $sms_plugin_com_sendsms_api = 'https://easysms.gr/api/sms/send';
	protected $sms_plugin_com_get_status_api = 'https://easysms.gr/api/status/get';
	protected $sms_plugin_com_callback_url = '/index.php?route=module/sms_plugin_com/smsCallback';
	protected $db;
	protected $helper;

	/**
	 * Call this method to get singleton
	 */
	public static function Instance()
	{
		static $inst = null;
		if ($inst === null) {
			$inst = new SmsPluginComApi();
		}
		return $inst;
	}

	/*
   * Private constructor so that it cannot be instantiated
   */
	private function __construct() {
		global $registry, $loader;
		$this->db = $registry->get('db');
		$this->helper = SmsPluginComHelper::Instance();
	}

	// Function to set credentials for API calls
	public function setApi($username, $password) {
		$this->sms_plugin_com_username = $username;
		$this->sms_plugin_com_password = $password;
	}

	public function responseHandler($response, $elements = array('status'), $status = false) {
		if (200 == $response['status_code']) {
			$json = json_decode($response['body']);
			// If response contains status just return the JSON.
			if ($status) {
				$response['body']  = $json;
			} else {
				// If not an error in API response.
				if ('0' === $json->{'error'}) {
					$body = array();
					foreach ($elements as $key) {
						$body[$key] = $json->{$key};
					}
					// Set body
					$response['body'] = $body;
				} else {
					// Just set status code 401.
					$response['status_code']  = 401;
				}
			}
		}
		return $response;
	}

	// Function to get the API key
	public function getKey($reset) {
		if(!$this->checkCredentials()) {
		   exit('Please set your SMS Plugin username and password');
		}

		// Prepare URL for get/reset API key call
		if($reset) {
			$get_key_api = $this->sms_plugin_com_reset_key_api;
		}
		else {
			$get_key_api = $this->sms_plugin_com_get_key_api;
		}

		$username = $this->sms_plugin_com_username;
		$password = $this->sms_plugin_com_password;
		$url = $get_key_api.'?username='.urldecode($username);
		$url .= '&password='.urldecode($password).'&type=json';

		// Make API call to get the key
		$response = $this->cURL($url);
	  $response = $this->responseHandler($response, array( 'status', 'key', 'remarks', 'error' ) );
		if( 200 === $response[ 'status_code' ] ) {
			$key = $this->get_if_set( $response['body']['key'] );
			// Check if not null and update the api-key in wp_options table
			if( null !== $key ) {
				$this->helper->setApikey($key);
			}
		}
		return $response;
	}

	// Function to get account balance
	public function getBalance($key) {
		if(!$key) {
			exit('Please provide an API key');
		}

		// Prepare URL for get balance API key call
		$get_balance_api = $this->sms_plugin_com_balance_api;
		$url = $get_balance_api.'?key='.$key.'&type=json';

		// Make API call to get balance
		$response = $this->cURL($url);
		$response = $this->responseHandler( $response, array( 'status', 'balance', 'remarks', 'error' ) );

		return $response;
	}

	 // Function to get status of messages (s (sent), d (delivered) or f (failed))
	public function getStatus($key) {
		if(!$key) {
			exit('Please provide an API key');
		}

		// Prepare URL for get balance API key call
		$get_status_api = $this->sms_plugin_com_get_status_api;
		$url = $get_status_api.'?key='.$key.'&type=json';

		// Make API call to get status
		$response = $this->cURL($url);

		return $response;
	}

	// Check if username and password are set
	private function checkCredentials() {
		if(!$this->sms_plugin_com_username || !$this->sms_plugin_com_password) {
			return false;
		} else {
			return true;
		}
	}

	// Function to send SMS
	public function sendSMS($key, $from, $to, $message, $encoding) {
		if(!$key || !$from || !$to || !$message || !isset($encoding)) {
		   exit('Please provide API key, from, to, message and encoding');
		}
		if($this->isSecure())
			$prot = 'https://';
		else
			$prot = 'http://';

		if(isset($_SERVER['HTTP_HOST']))
			$server = $prot . $_SERVER['HTTP_HOST'];
		else
			$server = $prot . $_SERVER['SERVER_NAME'];

		$parsedUrl = parse_url($_SERVER['REQUEST_URI']);
		$path = explode('/', $parsedUrl['path']);
		$index = array_search('index.php', $path);
		if($index) {
			array_pop($path);
		}

		$index = array_search('admin', $path);
		if($index) {
			array_pop($path);
		}

		$path = implode('/', $path);

		//Prepare URL for send SMS API key call
		$send_sms_api = $this->sms_plugin_com_sendsms_api;
		$url = $send_sms_api.'?key='.$key;
		$url .= '&to='.$to.'&from='.urlencode($from).'&text='.urlencode($message).
				($encoding == '0' ? '&ucs=true' : '').
				'&callback='.urlencode($server . $path . $this->sms_plugin_com_callback_url).
				'&type=json';

		// // Make API call to send SMS message
		$response = $this->cURL($url);
		$response = $this->responseHandler($response, array( 'status', 'id', 'balance', 'remarks' ), true );
		return $response;
	}

	// Use cURL for API Calls
	private function cURL($url) {
		$status_code = "";
		$response = [];

		if(extension_loaded('curl')) {
			$http = curl_init($url);
			curl_setopt($http, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($http, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($http);
			$status_code = curl_getinfo($http, CURLINFO_HTTP_CODE);
			if(curl_errno($http)) {
				throw new Exception(curl_error($http));
			}
			curl_close($http);
		} else {
			$fp = fopen($url, 'r');
			$response = fread($fp, 1024);
			$status_code = explode(' ', $http_response_header[0]);
			$status_code = (int)$status_code[1];
		}

		return array(
			'status_code' => $status_code,
			'body' => $response,
		);
	}

	// Log response and related data
	public function logResponse($response, $from, $to, $message, $status, $gsm_encoding, $order_id) {
			$sql = "INSERT INTO `" . DB_PREFIX . "sms_plugin_com` SET smsplugin_id = '" . $this->db->escape($response['body']->{'id'}) .
									"', sender_id = '" . $this->db->escape($from) .
									"', `to` = '" . $this->db->escape($to) .
									"', status = '" . $this->db->escape($status) .
									"', status_tstamp = NOW()" .
									", message = '" . $this->db->escape($message) .
									"', gsm_encoding = '" . $this->db->escape($gsm_encoding) .
									"', order_id = '" . (int)$this->db->escape($order_id) .
									"', send_tstamp = NOW()";
			$query = $this->db->query($sql);
	}

	// Update status from callback response
	public function updateResponse($msgid, $status) {

			$sql = "UPDATE `" . DB_PREFIX . "sms_plugin_com` SET status = '" . $this->db->escape($status) .
											"' WHERE smsplugin_id = '" . $this->db->escape($msgid) . "'";

			$query = $this->db->query($sql);
			return $query;
	}

	public function isSecure() {
		return
			(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
			|| $_SERVER['SERVER_PORT'] == 443;
	}

	public function get_if_set( &$value, $default = null ) {
		return isset( $value ) ? $value : $default;
	}

}
