<?php
/**
 * Implementation of the abstract Sms_Plugin_Com_Helper_Base class.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes/helper
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

/**
 * Defines a class that inherits from abstract class
 * Sms_Plugin_Com_Helper_Base
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes/helper
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

require_once dirname( __FILE__ ) . '/class-sms-plugin-com-helper-base.php';

/**
 * Class Sms_Plugin_Com_Helper inherits from Sms_Plugin_Com_Helper_Base
 * and it is a singleton.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes
 * @author     sms-plugin.com <yannis@tern.gr>
 * @since 1.0.0
 */
class Sms_Plugin_Com_Helper extends Sms_Plugin_Com_Helper_Base {
  /**
	 * The plugin instance
	 *
	 * @var Sms_Plugin_Com_Helper instance
	 * @since 1.0.0
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	protected function __construct() {
		parent::__construct();
	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Plugin_Com_Helper
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Plugin_Com_Helper ) ) {
			self::$instance = new Sms_Plugin_Com_Helper();
		}
		return self::$instance;
	}
}
