<?php
/**
 * Layout view that encloses plugin tabs.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/admin/partials
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @link       https://www.sms-plugin.com
 * @since      1.0.0
 *
 */
?>

<div class="wrap">

	<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>

	<h2 class="nav-tab-wrapper">
			<a href="#account" class="nav-tab nav-tab-active"><?php _e( 'Account', $this->plugin_name ); ?></a>
			<a href="#actions" class="nav-tab"><?php _e( 'Actions', $this->plugin_name ); ?></a>
			<a href="#history" class="nav-tab"><?php _e( 'History', $this->plugin_name ); ?></a>
	</h2>

		<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-2">
					<!-- main content -->
						<div id="post-body-content">
							<form method="post" id="<?php echo $this->plugin_name; ?>" name="<?php echo $this->plugin_name; ?>" action="options.php">
								<?php
									//Get options
									$options = get_option($this->plugin_name);
									settings_fields($this->plugin_name);
									do_settings_sections($this->plugin_name);
									require_once('sms-plugin-com-account.php');
									require_once('sms-plugin-com-actions.php');
									submit_button(__('Save changes', $this->plugin_name), 'primary','submit', FALSE);
								?>
						 </form>
						 <?php 	require_once('sms-plugin-com-history.php');; ?>
					 </div><!-- post-body-content -->
					<!-- sidebar -->
					<br>
					<div id="postbox-container-1" class="postbox-container">
						<div class="meta-box-sortables">
							<div class="postbox">
								<h3 class="hndle"><span>
								<?php
								esc_attr_e('About SMS Plugin for WooCommerce', $this->plugin_name);
								?>
								</span></h2>
								<div class="inside">
									<p>
									<div class="side-box-header">
										<img src="<?php echo SMS_PLUGIN_COM_URL . 'images/sms_plugin_about_logo.png';?>"/>
										<p>
											<strong>SMS Plugin for WooCommerce v<?php echo $this->version ?></strong><br>
											by <a href="http://www.sms-plugin.com">SMS Plugin</a><br>
											To use this module, please create an account <a href="https://easysms.gr/app/sign-up">here</a><br>
											Frequenlty Asked Questions (FAQ) <a href="https://easysms.gr/app/sms-faq">here</a>
										</p>
									</div><hr>
									<?php
									esc_attr_e('SMS Plugin for WooCommerce is an add-on that allows you send SMS notifications to your customers and to the site
														  Administrator about order status changes and new orders. SMS Plugin for WooCommerce allows Administrator SMS notifications
															for customer sign-ups and on-demand SMS messages to any international mobile phone number', $this->plugin_name);
									?>
									</p>
								</div><!-- .inside -->
							</div><!-- .postbox -->
						</div><!-- .meta-box-sortables -->
					</div><!-- #postbox-container-1 .postbox-container -->
			</div><!-- #post-body .metabox-holder .columns-2 -->
			<br class="clear">
		</div><!-- #poststuff -->
</div>
