/**
 * Javascript to handle the get-key action
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/api/js
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

if (typeof(console) == 'object') {
	console.log( 'get-key script loaded' );
}

var params = sms_plugin_com_get_key;
// Set validation Rules
var get_key_rules = {
		username: {
			required: true,
			messages: {
				required:  params.username_missing
			}
		},
		password: {
			required: true,
			messages: {
				required:  params.password_missing
			}
		}
};

// Document ready
(function($) {
	  // Get Key click handler
	  jQuery( '#get-key' ).click(function() {
				add_validation_rules(get_key_rules);
				// Get parameters enqueued by PHP
				if(jQuery( "#sms_plugin_com").valid()) {
					var username = jQuery( '#username' ).val();
					var password = jQuery( '#password' ).val();
					// The data to post to admin-ajax.php
					var data = {
						action: 'get_key',
						username: username,
						password: password,
						reset: false
					};
					get_key(data, '#sms_plugin_com-api-key', function() {
						return get_balance({action: 'get_balance'}, '#balance');
					});
				}
				remove_validation_rules(get_key_rules);
			});
})(jQuery);
