/**
 * This is javascript code that handles admin tabs and
 * plugin functionality
 *
 */
(function( $ ) {
	'use strict';

	 // IIFE Immediately-Invoked Function Expression
	 $(function() {
		 // tabs
		 var $tabBoxes = $('.sms_plugin_com-metaboxes');
		 var $tabLinkActive;
		 var $currentTab;
		 var $currentTabLink;
		 var $tabContent;
		 var $hash;
		 var $showChild = $(".show-child-if-checked");

		 // Tabs on load
		 if(window.location.hash){
			 $hash = window.location.hash;
			 $tabBoxes.addClass('hidden');
			 $currentTab = $($hash).toggleClass('hidden');
			 hideSaveButton($currentTab.selector);
			 saveTab($currentTab);
			 $('.nav-tab').removeClass('nav-tab-active');
			 $('.nav-tab[href='+$hash+']').addClass('nav-tab-active');
		 }
		 //Tabs on click
		 $('.nav-tab-wrapper').on('click', 'a', function(e){
			 e.preventDefault();
			 $tabContent = $(this).attr('href');
			 $('.nav-tab').removeClass('nav-tab-active');
			 $tabBoxes.addClass('hidden');
			 $currentTab = $($tabContent).toggleClass('hidden');
			 hideSaveButton($currentTab.selector);
			 saveTab($currentTab);
			 $(this).addClass('nav-tab-active');
				if(history.pushState) {
				 history.pushState(null, null, $tabContent);
			 }
			 else {
				 location.hash = $tabContent;
			 }
		 });

		 // Save tab id in browser's local storage
		 var tab_id = localStorage.getItem('tab_id');

		 $('a.nav-tab').removeClass('nav-tab-active');
		 $('a[href="' + tab_id + '"]').addClass('nav-tab-active').trigger("click");

		 // Toggle checkbox values
		 $('input:checkbox').change(function() {
				this.checked ? this.value = 'true' : this.value = 'false';
		 });

		 // Set upo History table datepicker
		 $('#search_id-search-input').datepicker({
			  constrainInput: false,
				dateFormat : 'yy-mm-dd',
				showOn: "button",
				buttonText: "<i class='fa fa-calendar'></i>",
		    buttonTextOnly: true
		 });

		 // Init validator
		 $('#sms_plugin_com').validate({});
	 });

	 // Save current tab in borowser's local storage
	 function saveTab(currentTab) {
		 localStorage.setItem('tab_id', currentTab.selector);
	 }

	 // Hide save button in History tab
	 function hideSaveButton(tab_id) {
		 if(tab_id === "#history") {
			 $('#submit').addClass('hidden');
		 } else {
			 $('#submit').removeClass('hidden');
		 }
	 }

	 // Add the check_sender_id function to String prototype
	 add_string_prototype();

})( jQuery );
