<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.sms-plugin.com
 * @since             1.0.0
 * @package           Sms_Plugin_Com
 *
 * @wordpress-plugin
 * Plugin Name:       SMS Plugin for WooCommerce
 * Plugin URI:        https://bitbucket.org/ymarios/wordpress-4.8
 * Description:       This is a plugin for WooCommerce developed by sms-plugin.com.
 * Version:           1.0.0
 * Author:            sms-plugin.com
 * Author URI:        https://bitbucket.org/ymarios/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       sms-plugin-com
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sms-plugin-com-activator.php
 *
 * @since    1.0.0
 */
function activate_sms_plugin_com() {
	if( class_exists( 'WooCommerce' ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-sms-plugin-com-activator.php';
		Sms_Plugin_Com_Activator::activate();
	} else {
		woocommerce_not_installed_or_deactivated();
	}
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sms-plugin-com-deactivator.php
 *
 * @since    1.0.0
 */
function deactivate_sms_plugin_com() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sms-plugin-com-deactivator.php';
	Sms_Plugin_Com_Deactivator::deactivate();
}

/**
 * Sets a transient message which fires plugin deactivation
 *
 * @since    1.0.0
 */
function woocommerce_not_installed_or_deactivated() {
	set_transient('wc-not-installed-or-deactivated-admin-notice', true, 5);
}

register_activation_hook( __FILE__, 'activate_sms_plugin_com' );
register_deactivation_hook( __FILE__, 'deactivate_sms_plugin_com' );

// Deactivate plugin on WooCommerce deactivation
register_deactivation_hook( 'woocommerce/woocommerce.php', 'woocommerce_not_installed_or_deactivated' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-sms-plugin-com.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_sms_plugin_com() {

	$plugin = new Sms_Plugin_Com();
	$plugin->run();

}
// Run the Plugin.
run_sms_plugin_com();
