<?php
/**
 * Account settings and send SMS tab partial view.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/admin/partials
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @link       https://www.sms-plugin.com
 * @since      1.0.0
 *
 */
?>

<!-- ACCOUNT TAB-->
<div id="account" class="wrap metabox-holder columns-2 sms_plugin_com-metaboxes">

	<!-- ACCOUNT INFO -->
  <div class="meta-box-sortables ui-sortable">
    <div class="postbox">
      <h3 class="hndle"><span><?php esc_attr_e( 'Account Info', $this->plugin_name ); ?></span></h2><br>
      <div class="inside">
        <table>
          <tbody>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Balance:', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <div id="balance-div" class="hidden">
                  <span id="balance" class="number-circle">-</span>
                  <span class="balance-sms"><?php esc_attr_e( 'sms', $this->plugin_name ); ?></span>
                </div>
                <div class="loader">
                  <img src="<?php echo SMS_PLUGIN_COM_URL . 'images/ripple.svg';?>"/>
                </div>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label" rowspan="3">
                <label><?php esc_attr_e( 'API Key:', $this->plugin_name ); ?></label>
              </td>
            </tr>
            <tr>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-api-key" name="<?php echo $this->plugin_name; ?>[api-key]" type="text" value="<?php if(!empty($options['api-key'])) echo $options['api-key']; ?>"
                       placeholder="<?php esc_attr_e('API Key', $this->plugin_name); ?>" readonly/>
                  <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Your sms-plugin.com API key', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td class="keys">
                <input id="get-key" name="get-key" class="button-primary" type="button" value="<?php esc_attr_e( 'Get Key', $this->plugin_name  ); ?>" />
                <input id="reset-key" name="reset-key" class="button-primary" type="button" value="<?php esc_attr_e( 'Reset Key', $this->plugin_name  ); ?>" />
              </td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Username *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="username" name="username" type="text" value="" placeholder="<?php esc_attr_e('Username', $this->plugin_name); ?>"/>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Your sms-plugin.com account username', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Password *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="password" name="password" type="password" value="" placeholder="<?php esc_attr_e('Password', $this->plugin_name); ?>"/>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Your sms-plugin.com account password', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
          </tbody>
        </table>
      </div><!-- .inside -->
    </div><!-- .postbox -->
  </div><!-- .meta-box-sortables .ui-sortable -->

	<!-- SEND SMS -->
  <div class="meta-box-sortables ui-sortable">
    <div class="postbox">
      <h3 class="hndle"><span><?php esc_attr_e( 'Send SMS', $this->plugin_name ); ?></span></h2><br>
      <div class="inside">
        <table>
          <tbody>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Sender *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="sender" name="sender" width="70%" type="text" value="" placeholder="<?php esc_attr_e( 'Name', $this->plugin_name ); ?>">
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS sender. You can enter upto 16 numeric or 11 alphanumeric characters. Nameσ over 16 numeric or 11 alphanumeric characters characters will be cut out', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Recipient *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="recipient" name="recipient" type="text" value="" placeholder="<?php esc_attr_e( 'Mobile', $this->plugin_name ); ?>"/>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'The SMS recipient. Must be a valid mobile phone number', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Encoding', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="send-sms-encoding" name="send-sms-encoding">
                  <option value="1"><?php esc_attr_e( 'GSM', $this->plugin_name ); ?></option>
                  <option value="2"><?php esc_attr_e( 'UCS', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS encoding. GSM encoding = 157 characters per sms ( some special characters may count for 2 characters ). UCS = 67 characters per sms', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Text *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="send-sms-message" name="send-sms-message" rows="10" class="all-options" placeholder="<?php esc_html__( 'SMS text', $this->plugin_name ); ?>"></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS message. Max 918 characters. Lengthy texts (over 160 characters for GSM encoding and 70 characters for UCS encoding) may incur additional charges', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td></td>
              <td id="send-sms-counter"><span id="send-sms-counter-char" class="counter">0</span>&nbsp;
                <span id="char-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="send-sms-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
            <tr>
              <td></td>
              <td>
                <input id="send-sms" name="send-sms" class="button-primary" type="button" value="<?php esc_attr_e( 'Send', $this->plugin_name  ); ?>" />
              </td>
            </tr>
          </tbody>
        </table>
      </div><!-- .inside -->
    </div><!-- .postbox -->
  </div><!-- .meta-box-sortables .ui-sortable -->

</div><!-- #account -->
