<?php
/**
 * The file that defines the uninstaller class
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

 /**
  * The class responsible to provide basic database functionality to other classes that
  * inherit from it.
  */
 require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/model/class-sms-plugin-com-base-model.php';

 /**
  * The class that manages the main plugin datbase table. This table stores sms history.
  */
 require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/model/class-sms-plugin-com-model.php';

/**
 * The class that performs cleanup upon uninstallation
 *
 * This is used to  among others todelete the sms_plugin_com database table
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */
class Sms_Plugin_Com_Uninstaller {
	/**
	 * This function is used to delete database tables
	 *
	 * @return void
	 */
	public static function delete_database_tables() {
		/**
	 * Use Sms_Plugin_Com_Model method delete_sms_plugin_com_table
	 * to delete database tables
	 */
		Sms_Plugin_Com_Model::instance()->delete_sms_plugin_com_table();
	}
}
