<?php
/**
 * Defines a class that inherits from abstract class
 * Sms_Plugin_Com_Wc_Base
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/woocommerce
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

require_once dirname( __FILE__ ) . '/class-sms-plugin-com-wc-base.php';

/**
 * Class Sms_Plugin_Com_Wc_base inherits from Sms_Plugin_Com_Api_Base
 * and it is a singleton.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/woocommerce
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */
class Sms_Plugin_Com_Wc extends Sms_Plugin_Com_Wc_Base {
  /**
	 * The plugin instance
	 *
	 * @var Sms_Plugin_Com_Wc instance
	 * @since 1.0.0
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	protected function __construct() {
 		parent::__construct();
 	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Plugin_Com_Wc
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Plugin_Com_Wc ) ) {
			self::$instance = new Sms_Plugin_Com_Wc();
		}
		return self::$instance;
	}
}
