<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/admin
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

/**
 *
 * Defines the plugin name, version, and enqueues
 * the admin-specific stylesheet and JavaScript.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/admin
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */
class Sms_Plugin_Com_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since       1.0.0
	 * @access  private
	 * @var     string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since   1.0.0
	 * @access  private
	 * @var     string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * The message history table.
	 *
	 * @since   1.0.0
	 * @access  private
	 * @var     string    $plugin_name    The ID of this plugin.
	 */
	private $message_table;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @param   string $plugin_name       The name of this plugin.
	 * @param   string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since   1.0.0
	 * @access  public
	 */
	public function enqueue_styles() {
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/sms-plugin-com-admin.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . '-balloon', plugin_dir_url( __FILE__ ) . 'css/balloon.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . '-jquery-ui', plugin_dir_url( __FILE__ ) . 'css/jquery-ui/jquery-ui.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . '-font-awesome', plugin_dir_url( __FILE__ ) . 'css/font-awesome-4.7.0/css/font-awesome.min.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since   1.0.0
	 * @access  public
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( $this->plugin_name . '-jquery-validate', plugin_dir_url( __FILE__ ) . 'js/jquery.validate.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name . '-functions', plugin_dir_url( __FILE__ ) . 'js/sms-plugin-com-functions.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/sms-plugin-com-admin.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script('jquery-ui-datepicker');
	}

	/**
	 * Register the administration menu for this plugin into the WordPress Dashboard menu.
	 *
	 * @since   1.0.0
	 * @access  public
	 */
	public function add_plugin_admin_menu() {

		/**
		 * Add a settings page for this plugin to the Settings menu.
		 */
		add_options_page( __( 'SMS Plugin for WooCommerce Setup', $this->plugin_name ), 'SMS Plugin', 'manage_options', $this->plugin_name, array( $this, 'display_plugin_setup_page' ) );
	}


	/**
	 * Add settings action link to the plugins page.
	 *
	 * @since       1.0.0
	 * @param       array $links settings links.
	 * @access  public
	 */
	public function add_action_links( $links ) {
		return array_merge(
			array(
				'settings' => '<a href="' . admin_url( 'options-general.php?page=' . $this->plugin_name ) . '">' . __( 'Settings', $this->plugin_name ) . '</a>',
			),
			$links
		);
	}

	/**
	 * Render the settings page for this plugin.
	 *
	 * @since   1.0.0
	 * @access  public
	 */
	public function display_plugin_setup_page() {
		include_once( 'partials/sms-plugin-com-admin-display.php' );
	}

	/**
	 * Saves/Updates plugin options in the database
	 *
	 * @since       1.0.0
	 * @access  public
	 */
	public function options_update() {
		register_setting( $this->plugin_name, $this->plugin_name, array( $this, 'validate' ) );
	}

	/**
	 * Validate and sanitize inputs/options
	 * for saving
	 *
	 * @since   1.0.0
	 * @access  public
	 * @param   array $input array of form input values.
	 * @return  array $valid validated inputs
	 */
	public function validate( $input ) {
		// All inputs.
		$valid = array();

		// Check validity of API key.
		$valid['api-key'] = ( isset( $input['api-key'] ) && ! empty( $input['api-key'] ) && ctype_alnum( $input['api-key'] ) )
											? sanitize_text_field( $input['api-key'] )
											: add_settings_error(
												'API Key',
												'api_key_error_texterror',
												__( 'Enter credentials to get an API key', $this->plugin_name ),
												'error'
											);
		// Check validity of new order SMS select input.
		$valid['new-order-send-sms'] = ( isset( $input['new-order-send-sms'] ) && ! empty( $input['new-order-send-sms'] ) && in_array( $input['new-order-send-sms'] , [ 'true', 'false' ], true ) == 1)
																 ? sanitize_text_field( ( $input['new-order-send-sms'] ) )
																 : add_settings_error(
																	 'Send SMS on new order',
																	 'new_order_send_sms_error_texterror',
																	 __( 'Invalid value for: Send SMS on new order', $this->plugin_name ),
																	 'error'
																 );
		// Check validity of new order SMS sender.
		$valid['new-order-sender'] = ( isset( $input['new-order-sender'] ) &&
																	 ! empty( $input['new-order-sender'] ) &&
																	 ( ( strlen( $input['new-order-sender'] ) <= 16 && ctype_digit( $input['new-order-sender'] ) ) ||
																	   ( strlen( $input['new-order-sender'] ) <= 11 && ctype_alnum( $input['new-order-sender'] ) ) ||
																		 ( strlen( $input['new-order-sender'] ) <= 11 && ctype_alpha( $input['new-order-sender'] ) )
																		 ) )
															 ? sanitize_text_field( $input['new-order-sender'] )
															 : add_settings_error(
																 'New order SMS sender',
																 'new_order_sms_sender_error_texterror',
																 __( 'Invalid value for: New order SMS sender must be alphanumeric max 11 characters or numeric max 16 digits', $this->plugin_name ),
																 'error'
															 );
		 // Check validity of new order SMS encoding select input.
 		$valid['new-order-encoding'] = ( isset( $input['new-order-encoding'] ) && ! empty( $input['new-order-encoding'] ) && in_array( $input['new-order-encoding'] , [ '1', '2' ], true ) == 1)
 																 ? sanitize_text_field( ( $input['new-order-encoding'] ) )
 																 : add_settings_error(
 																	 'New Order SMS encoding',
 																	 'new_order_encoding_error_texterror',
 																	 __( 'Invalid value for: New Order SMS encoding', $this->plugin_name ),
 																	 'error'
 																 );
		// Check validity of new order SMS text.
		$valid['new-order-sms-text'] = ( isset( $input['new-order-sms-text'] ) && ! empty( $input['new-order-sms-text'] ) && strlen( $input['new-order-sms-text'] ) <= 918)
																? sanitize_text_field( $input['new-order-sms-text'] )
																: add_settings_error(
																	'New order SMS text',
																	'new_order_sms_text_error_texterror',
																	__( 'Invalid value for: New order SMS text must be greater than 0 and equal or less than 918 characters', $this->plugin_name ),
																	'error'
																);

		// Check validity of order status SMS select input.
		$valid['order-status-send-sms'] = ( isset( $input['order-status-send-sms'] ) && ! empty( $input['order-status-send-sms'] ) && in_array( $input['order-status-send-sms'] , [ 'true', 'false' ], true ) == 1)
																 ? sanitize_text_field( ( $input['order-status-send-sms'] ) )
																 : add_settings_error(
																	 'Send SMS on order status change',
																	 'order_status_send_sms_error_texterror',
																	 __( 'Invalid value for: Send SMS on order status change', $this->plugin_name ),
																	 'error'
																 );
		// Check validity of order status SMS sender.
		$valid['order-status-sender'] = ( isset( $input['order-status-sender'] ) &&
																	 		! empty( $input['order-status-sender'] ) &&
																	 ( ( strlen( $input['order-status-sender'] ) <= 16 && ctype_digit( $input['order-status-sender'] ) ) ||
																	   ( strlen( $input['order-status-sender'] ) <= 11 && ctype_alnum( $input['order-status-sender'] ) ) ||
																		 ( strlen( $input['order-status-sender'] ) <= 11 && ctype_alpha( $input['order-status-sender'] ) )
																		) )
																 ? sanitize_text_field( $input['order-status-sender'] )
																 : add_settings_error(
																	 'Order status change SMS sender',
																	 'order_status_sms_sender_error_texterror',
																	 __( 'Invalid value for: Order status change SMS sender alphanumeric max 11 characters or numeric max 16 digits', $this->plugin_name ),
																	 'error'
																 );
	  // Check validity of order status SMS encoding select input.
		$valid['order-status-encoding'] = ( isset( $input['order-status-encoding'] ) && ! empty( $input['order-status-encoding'] ) && in_array( $input['order-status-encoding'] , [ '1', '2' ], true ) == 1)
																 ? sanitize_text_field( ( $input['order-status-encoding'] ) )
																 : add_settings_error(
																	 'Order status change SMS encoding',
																	 'order_status_encoding_error_texterror',
																	 __( 'Invalid value for: Order status change SMS encoding', $this->plugin_name ),
																	 'error'
																 );
		// Check validity of order status SMS text.
		$valid['order-status-sms-text'] = ( isset( $input['order-status-sms-text'] ) && ! empty( $input['order-status-sms-text'] ) && strlen( $input['order-status-sms-text'] ) <= 918 )
																	? sanitize_text_field( $input['order-status-sms-text'] )
																	: add_settings_error(
																		'Order status change SMS text',
																		'order_status_text_error_texterror',
																		__( 'Invalid value for: Order status change SMS text must be greater than 0 and equal or less than 918 characters', $this->plugin_name ),
																		'error'
																	);
		// Check validity of Notify Admin select input.
		$valid['admin-notify'] = ( isset( $input['admin-notify'] ) && ! empty( $input['admin-notify'] ) && in_array( $input['admin-notify'] , [ 'true', 'false' ], true ) == 1)
																 ? sanitize_text_field( ( $input['admin-notify'] ) )
																 : add_settings_error(
																	 'Notify Admin',
																	 'notify_admin_error_texterror',
																	 __( 'Invalid value for: Notify Admin', $this->plugin_name ),
																	 'error'
																 );
		// Check validity of order status SMS sender.
 		$valid['admin-mobile'] = ( isset( $input['admin-mobile'] ) && ! empty( $input['admin-mobile'] ) && ctype_digit( $input['admin-mobile'] ) )
 																 ?  $input['admin-mobile']
 																 : add_settings_error(
 																	 'Admin mobile',
 																	 'admin_mobile_error_texterror',
 																	 __( 'Invalid value for: Admin mobile must be digits only', $this->plugin_name ),
 																	 'error'
 																 );

		 // Check validity of admin notifications SMS encoding select input.
 		$valid['admin-notify-encoding'] = ( isset( $input['admin-notify-encoding'] ) && ! empty( $input['admin-notify-encoding'] ) && in_array( $input['admin-notify-encoding'] , [ '1', '2' ], true ) == 1)
 																 ? sanitize_text_field( ( $input['admin-notify-encoding'] ) )
 																 : add_settings_error(
 																	 'Admin Notify SMS encoding',
 																	 'admin_notify_encoding_error_texterror',
 																	 __( 'Invalid value for: Admin notifications SMS encoding', $this->plugin_name ),
 																	 'error'
 																 );

	 // Check validity of notify admin on new user registration.
	 $valid['admin-notify-new-account'] = ( in_array( $input['admin-notify-new-account'] , [ 'true', null ], true ) == 1 )
																 ?  $input['admin-notify-new-account']
																 : add_settings_error(
																	 'Admin notify on new account',
																	 'admin_notify_new_account_error_texterror',
																	 __( 'Invalid value for: Admin notify on new account', $this->plugin_name ),
																	 'error'
																 );

	 // Check validity of admin notify new account SMS text.
	 $valid['admin-notify-new-account-sms-text'] = ( isset( $input['admin-notify-new-account-sms-text'] ) && ! empty( $input['admin-notify-new-account-sms-text'] ) && strlen( $input['admin-notify-new-account-sms-text'] ) <= 918 )
																 ? sanitize_text_field( $input['admin-notify-new-account-sms-text'] )
																 : add_settings_error(
																	 'Admin notify new account SMS text',
																	 'admin_notify_new_account_text_error_texterror',
																	 __( 'Invalid value for: Admin notify new account change SMS text must be greater than 0 and equal or less than 918 characters', $this->plugin_name ),
																	 'error'
																 );

	 // Check validity of notify admin on customer checkout.
	 $valid['admin-notify-customer-checkout'] = ( in_array( $input['admin-notify-customer-checkout'] , [ 'true', null ], true ) == 1 )
																 ?  $input['admin-notify-customer-checkout']
																 : add_settings_error(
																	 'Admin notify on customer checkout',
																	 'admin_notify_customer_checkout_error_texterror',
																	 __( 'Invalid value for: Admin notify on customer checkout', $this->plugin_name ),
																	 'error'
																 );

	 // Check validity of admin notify on cutomer checkout SMS text.
	 $valid['admin-notify-customer-checkout-sms-text'] = ( isset( $input['admin-notify-customer-checkout-sms-text'] ) && ! empty( $input['admin-notify-customer-checkout-sms-text'] ) && strlen( $input['admin-notify-customer-checkout-sms-text'] ) <= 918 )
																 ? sanitize_text_field( $input['admin-notify-customer-checkout-sms-text'] )
																 : add_settings_error(
																	 'Admin notify customer checkout SMS text',
																	 'admin_notify_customer_checkout_text_error_texterror',
																	 __( 'Invalid value for: Admin notify customer checkout change SMS text must be greater than 0 and equal or less than 918 characters', $this->plugin_name ),
																	 'error'
																 );
	 // Check validity of notify admin on customer checkout.
	 $valid['admin-notify-order-status'] = ( in_array( $input['admin-notify-order-status'] , [ 'true', null ], true ) == 1 )
																 ?  $input['admin-notify-order-status']
																 : add_settings_error(
																	 'Admin notify on order status change',
																	 'admin_notify_order_status_change_error_texterror',
																	 __( 'Invalid value for: Admin notify on order status change', $this->plugin_name ),
																	 'error'
																 );

	 // Check validity of admin notify on order status change SMS text.
	 $valid['admin-notify-order-status-sms-text'] = ( isset( $input['admin-notify-order-status-sms-text'] ) && ! empty( $input['admin-notify-order-status-sms-text'] ) && strlen( $input['admin-notify-order-status-sms-text'] ) <= 918 )
																 ? sanitize_text_field( $input['admin-notify-order-status-sms-text'] )
																 : add_settings_error(
																	 'Admin notify order status change SMS text',
																	 'admin_notify_order_status_change_text_error_texterror',
																	 __( 'Invalid value for: Admin notify on order status change SMS text must be greater than 0 and equal or less than 918 characters', $this->plugin_name ),
																	 'error'
																 );
		return $valid;
	}

	/**
	 * Used to get the current screen
	 * @since		1.0.0
	 * @access  public
	 * @param  string $screen
	 * @return WP_Screen The WP_Screen Object
	 */
	public function my_current_screen($screen) {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) return $screen;
		return $screen;
	}

	/**
	 * Used to return an empty array in order to
	 * hide visual elements such as Bulk actions in
	 * History table
	 *
	 * @since		1.0.0
	 * @access  public
	 * @return array an empty array
	 */
	public function return_empty_array() {
    return array();
	}

}
