<?php
/**
 * Defines the internationalization functionality
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

/**
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */
class Sms_Plugin_Com_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'sms_plugin_com',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

		load_plugin_textdomain(
			'woocommerce',
			false,
			dirname(plugin_dir_path( __DIR__ )) . '/woocommerce/i18n/languages/'
		);
	}



}
