<?php
/**
 * The file that provides functionality to manage the main
 * plugin table which stores sms history
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes/model
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

/**
 *
 * It inherits basic datbase functionatlity from the abstract
 * class Sms_Plugin_Com_Base_Model
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes/model
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

require_once  dirname( __FILE__ ) . '/class-sms-plugin-com-base-model.php';

/**
 * The class that manages the main Sms_Plugin_Com database table
 *
 * This is used to create.delete the sms_plugin_com datbase table
 *
 * @since      1.0.0
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/includes/model
 * @author     sms-plugin.com <yannis@tern.gr>
 */
class Sms_Plugin_Com_Model extends Sms_Plugin_Com_Base_Model {
	/**
	 * Table Name constant
	 *
	 * @since 1.0.0
	 * @var string
	 */
	const TABLE_NAME = 'sms_plugin_com';

	/**
	 * The plugin instance
	 *
	 * @var Sms_Plugin_Com_Model instance
	 * @since	1.0.0
	 * @access	private
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {
		$this->set_table_name( self::TABLE_NAME );
	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Plugin_Com_Model
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Plugin_Com_Model ) ) {
			self::$instance = new Sms_Plugin_Com_Model();
		}
		return self::$instance;
	}

	/**
	 * Function create_sms_plugin_com_table
	 *
	 * Creates sms_plugin_com table
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function create_sms_plugin_com_table() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		$sql = 'CREATE TABLE IF NOT EXISTS ' . $this->get_table_name() . " (
                   smsplugin_id int(10) unsigned NOT NULL AUTO_INCREMENT,
                   send_tstamp datetime NOT NULL,
                   sender_id text NOT NULL,
                   `to` text NOT NULL,
                   message text NOT NULL,
                   status text NOT NULL,
                   status_tstamp datetime NOT NULL,
                   gsm_encoding binary NOT NULL,
                   order_id int(10) unsigned DEFAULT NULL,
                   PRIMARY KEY (smsplugin_id)
                ) $charset_collate;";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );
		if ( $wpdb->last_error ){
			Sms_Plugin_Com_Logger::instance()->log( $wpdb->last_error );
		}
	}

	/**
	 * Function create_sms_plugin_com_table
	 *
	 * Deletes sms_plugin_com table
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function delete_sms_plugin_com_table() {
		 global $wpdb;
		 $sql = 'DROP TABLE IF EXISTS ' . $this->get_table_name();
		  $wpdb->query( $sql );
		 if ( $wpdb->last_error ){
			 Sms_Plugin_Com_Logger::instance()->log( $wpdb->last_error );
		 }
	}
}
