<?php
/**
 * Provides logging functionality.
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/tools
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */

/**
 * This is a basic logger that enables us to write text to a file
 *
 * @package    Sms_Plugin_Com
 * @subpackage Sms_Plugin_Com/tools
 * @link       https://www.sms-plugin.com
 * @author     sms-plugin.com <info@sms-plugin.com>
 * @since 1.0.0
 */
class Sms_Plugin_Com_Logger {
	/**
   * Log file path
	 *
   * @var string
   */
	const FILE_PATH = SMS_PLUGIN_COM_DIR . '/debug.log';

	/**
	 * The logger instance
	 *
	 * @var 		SMS_PLUGIN_COM_LOGGER instance
	 * @since 	1.0.0
	 * @access	private
	 */
	private static $instance;

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return SMS_PLUGIN_COM_LOGGER
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Plugin_Com_Logger ) ) {
			self::$instance = new Sms_Plugin_Com_Logger();
		}
		return self::$instance;
	}

	/**
	 * Logging function
	 *
	 * @since 	1.0.0
	 * @access	public
	 * @param   string $text the text to log.
	 */
	public function log( $text ) {
		global $wp_filesystem;

		if ( empty( $wp_filesystem ) ) {
			  require_once( ABSPATH . '/wp-admin/includes/file.php' );
			  WP_Filesystem();
		}
		$time = date( 'd/m/Y H:i:s', time() + 10800 );
		$content = $wp_filesystem->get_contents(self::FILE_PATH);

		if ( is_array( $text ) || is_object( $text ) ) {
        $content .= "#$time\t". print_r($text, true) . "\r\n";
    } else {
        $content .= "#$time\t$text\r\n";
    }
		$wp_filesystem->put_contents( self::FILE_PATH, $content, FS_CHMOD_FILE );
	}

}
