<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 *
 * @link       https://sms-plugin.com/woocommerce/
 * @since      1.0.0
 *
 * @package    Sms_Plugin_Com
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Require the class that performs uninstallation cleanup.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'sms-plugin-com/includes/class-sms-plugin-com-uninstaller.php';

/**
 * Delete database tables upon uninstallation
 */
Sms_Plugin_Com_Uninstaller::delete_database_tables();
